CREATE INDEX art_ak_nr_like ON art(ak_nr varchar_pattern_ops);
CREATE INDEX art_bez_aeoeue ON art(AEOEUE_UPPER(ak_bez) varchar_pattern_ops);
CREATE INDEX art_mat_aeoeue ON art(AEOEUE_UPPER(ak_mat) varchar_pattern_ops) WHERE AEOEUE_UPPER(ak_mat) IS NOT NULL;
CREATE INDEX art_dim_aeoeue ON art(AEOEUE_UPPER(ak_dim) varchar_pattern_ops) WHERE AEOEUE_UPPER(ak_dim) IS NOT NULL;
CREATE INDEX art_ak_ac ON art(ak_ac);
CREATE INDEX art_verfueg ON art(ak_verfueg);
CREATE INDEX artikel_index ON art(tartikel.art__ak_nr__index(ak_nr) varchar_pattern_ops);                             -- 2. Parameter searchstring DEFAULT true
CREATE INDEX artikel_index_no_searchstring ON art(tartikel.art__ak_nr__index(ak_nr, false) varchar_pattern_ops);
CREATE INDEX ak_hersteller ON art(ak_hersteller varchar_pattern_ops) WHERE ak_hersteller IS NOT NULL;
CREATE INDEX ak_ersatzaknr ON art(ak_ersatzaknr varchar_pattern_ops) WHERE ak_ersatzaknr IS NOT NULL;
CREATE INDEX art__ak_lerkl_ad_krz ON art(ak_lerkl_ad_krz) WHERE ak_lerkl_ad_krz IS NOT NULL;
CREATE INDEX art__ak_lerkldatbis ON art(ak_lerkldatbis) WHERE ak_lerkldatbis IS NOT NULL;

CREATE INDEX akbl_txt ON artblang (akbl_txt);
CREATE UNIQUE INDEX akbl_spr_key ON artblang (akbl_ak_nr, akbl_spr_key); -- jeder Sprachschlüssel darf nur einmal zum Artikel zugeordnet werden

CREATE INDEX akml_txt ON artmlang (akml_txt); 
CREATE UNIQUE INDEX akml_spr_key ON artmlang (akml_ak_nr, akml_spr_key); 

CREATE INDEX akdl_txt ON artdlang (akdl_txt);
CREATE UNIQUE INDEX akdl_spr_key ON artdlang (akdl_ak_nr, akdl_spr_key);

CREATE UNIQUE INDEX xtt5022 ON stv (st_zn, st_pos);
CREATE INDEX stv_st_n ON stv (st_n);
CREATE INDEX stv_st_zn ON stv (st_zn);
CREATE INDEX stv_st_kstv_st_id ON stv (st_kstv_st_id) WHERE st_kstv_st_id IS NOT NULL;

ALTER TABLE  stv ADD FOREIGN KEY ( st_zn, st_pos_parent ) REFERENCES stv( st_zn, st_pos ) ON UPDATE CASCADE;

CREATE INDEX stvtrs_res_log_resid ON stvtrs_res_log(strl_resid);
CREATE UNIQUE INDEX resid ON stvtrs(resid, id, stv_str_revnr);
CREATE INDEX resid_askix ON stvtrs(resid, askix) WHERE askix IS NOT NULL;
CREATE INDEX stvtrs_abkix ON stvtrs(abkix);
CREATE INDEX stvtrs_parent_stvtrs_dbrid ON stvtrs(parent_stvtrs_dbrid);
CREATE INDEX stvtrs_auftg_ag_id ON stvtrs(auftg_ag_id) WHERE auftg_ag_id IS NOT NULL;
CREATE INDEX stvtrs_ksbedarf_resid ON stvtrs_ksbedarf(ksb_resid);

CREATE INDEX artcod_ic_ac ON artcod (ac_i, ac_n); 
